/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.core.internal;

import com.aptana.core.util.EclipseUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.osgi.framework.Bundle;

public class ProtocolLogger {
    private PrintWriter writer;

    public ProtocolLogger(String filename, String pluginId) throws DebugException {
        this(Platform.getStateLocation((Bundle)Platform.getBundle((String)pluginId)).append("logs").append(filename).addFileExtension("log"), pluginId);
    }

    public ProtocolLogger(IPath location, String pluginId) throws DebugException {
        File file = location.toFile();
        file.getParentFile().mkdirs();
        try {
            this.writer = new PrintWriter(new FileOutputStream(file), true);
            this.writer.println(MessageFormat.format("Logger started at: {0,date,full} {0,time,full}", new Date()));
            this.writer.println(MessageFormat.format("Component: {0}", pluginId));
            this.writer.println(MessageFormat.format("Version: {0}", EclipseUtil.getPluginVersion((String)pluginId)));
        }
        catch (FileNotFoundException e) {
            throw new DebugException((IStatus)new Status(4, "com.aptana.js.debug.core", 5010, "", (Throwable)e));
        }
    }

    public void log(boolean recv, String message) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        if (message.length() > 1024) {
            message = String.valueOf(message.substring(0, 1024)) + "..." + Integer.toString(message.length() - 1024);
        }
        this.writer.println(MessageFormat.format("[{0,number,##}:{1,number,##}.{2,number,###}] {3}: >{4}<", cal.get(12), cal.get(13), cal.get(14), recv ? "Recv" : "Sent", message));
    }

    public void close() {
        this.writer.println("----------End of file----------");
        this.writer.close();
    }
}

